﻿Imports System.ComponentModel

Public Class Student
    Implements INotifyPropertyChanged

    Public Event PropertyChanged As PropertyChangedEventHandler Implements System.ComponentModel.INotifyPropertyChanged.PropertyChanged

    Private _fullName As String
    Private _firstName As String
    Private _middleName As String
    Private _lastName As String
    Private _sex As String
    Private _photoFilename As String
    Private _gradePointAverage As Decimal


    Public Property FullName() As String
        Set(ByVal value As String)
            If _fullName <> value Then
                _fullName = value
                OnPropertyChanged("FullName")
            End If
        End Set
        Get
            Return _fullName
        End Get
    End Property


    Public Property FirstName() As String
        Set(ByVal value As String)
            If _firstName <> value Then
                _firstName = value
                OnPropertyChanged("FirstName")
            End If
        End Set
        Get
            Return _firstName
        End Get
    End Property


    Public Property MiddleName() As String
        Set(ByVal value As String)
            If _middleName <> value Then
                _middleName = value
                OnPropertyChanged("MiddleName")
            End If
        End Set
        Get
            Return _middleName
        End Get
    End Property


    Public Property LastName() As String
        Set(ByVal value As String)
            If _lastName <> value Then
                _lastName = value
                OnPropertyChanged("LastName")
            End If
        End Set
        Get
            Return _lastName
        End Get
    End Property


    Public Property Sex() As String
        Set(ByVal value As String)
            If _sex <> value Then
                _sex = value
                OnPropertyChanged("Sex")
            End If
        End Set
        Get
            Return _sex
        End Get
    End Property


    Public Property PhotoFilename() As String
        Set(ByVal value As String)
            If _photoFilename <> value Then
                _photoFilename = value
                OnPropertyChanged("PhotoFilename")
            End If
        End Set
        Get
            Return _photoFilename
        End Get
    End Property


    Public Property GradePointAverage() As Decimal
        Set(ByVal value As Decimal)
            If _gradePointAverage <> value Then
                _gradePointAverage = value
                OnPropertyChanged("GradePointAverage")
            End If
        End Set
        Get
            Return _gradePointAverage
        End Get
    End Property


    Protected Overridable Sub OnPropertyChanged(ByVal propChanged As String)
        RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(propChanged))
    End Sub
End Class